IF  NOT EXISTS (SELECT * 
                  FROM sys.objects 
			     WHERE object_id = OBJECT_ID(N'[dbo].[TELE_ORC_PAG_DUPLICATA_BOLETO]') 
			       AND type in (N'U')) 
BEGIN
	CREATE TABLE [dbo].[TELE_ORC_PAG_DUPLICATA_BOLETO](
		[CD_ORC_PAG_DUPLICATA_BOLETO] 	int IDENTITY(1,1) NOT NULL,
		[CD_ORC_PAG_DUPLICATA] 			int NOT NULL,
		[ADQUIRENTE] 					VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',	
		[NOSSO_NUMERO] 					VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',
		[NUMERO_DOCUMENTO] 				VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',
		[CODIGO_BARRAS] 				VARCHAR(50) COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS NOT NULL DEFAULT '',
		[DT_CAD] 						DATETIME NOT NULL DEFAULT CONVERT(VARCHAR(10),GETDATE(), 112),
		[DT_VENCTO] 					DATETIME NOT NULL DEFAULT CONVERT(VARCHAR(10),GETDATE(), 112),
	 CONSTRAINT [PK__TELE_ORC_PAG_DUPLICATA_BOLETO] PRIMARY KEY CLUSTERED 
	( [CD_ORC_PAG_DUPLICATA_BOLETO] ASC )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] 

	ALTER TABLE [dbo].[TELE_ORC_PAG_DUPLICATA_BOLETO]  WITH CHECK ADD  CONSTRAINT [FK__TELE_ORC_PAG_DUPLICATA_BOLETO__TELE_ORC_PAG_DUPLICATA] FOREIGN KEY([CD_ORC_PAG_DUPLICATA]) REFERENCES [dbo].[TELE_ORC_PAG_DUPLICATA] ([CD_ORC_PAG_DUPLICATA]) 
	ALTER TABLE [dbo].[TELE_ORC_PAG_DUPLICATA_BOLETO] CHECK CONSTRAINT [FK__TELE_ORC_PAG_DUPLICATA_BOLETO__TELE_ORC_PAG_DUPLICATA] 
END